//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//  
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Threading;
using System.Diagnostics;

namespace ThreadPoolTest
{
	/// <summary>
	/// Podsumowanie dla Form1.
	/// </summary>
	public class ThreadPoolTestForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button startButton;
		private System.Windows.Forms.TextBox appDomainCountTextBox;
		private int appDomainCount;

		/// <summary>
		/// Wymagana zmienna.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public ThreadPoolTestForm()
		{
			//
			// Wymagane do obsugi Windows Form Designer
			//
			InitializeComponent();

			appDomainCount = 0;

		}

		/// <summary>
		/// Oczyszczenie uywanych zasobw.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Metoda wymagana do obsugi Designera - nie naley modyfikowa
		/// zawartoci tej metody przy uyciu edytora kodu.
		/// </summary>
		private void InitializeComponent()
		{
			this.appDomainCountTextBox = new System.Windows.Forms.TextBox();
			this.startButton = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// appDomainCountTextBox
			// 
			this.appDomainCountTextBox.Location = new System.Drawing.Point(133, 10);
			this.appDomainCountTextBox.Name = "appDomainCountTextBox";
			this.appDomainCountTextBox.ReadOnly = true;
			this.appDomainCountTextBox.Size = new System.Drawing.Size(128, 22);
			this.appDomainCountTextBox.TabIndex = 1;
			this.appDomainCountTextBox.Text = "";
			// 
			// startButton
			// 
			this.startButton.Location = new System.Drawing.Point(10, 10);
			this.startButton.Name = "startButton";
			this.startButton.Size = new System.Drawing.Size(96, 28);
			this.startButton.TabIndex = 0;
			this.startButton.Text = "Start";
			this.startButton.Click += new System.EventHandler(this.OnStart);
			// 
			// ThreadPoolTestForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(6, 15);
			this.ClientSize = new System.Drawing.Size(336, 56);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.appDomainCountTextBox,
																		  this.startButton});
			this.Name = "ThreadPoolTestForm";
			this.Text = "Test asynchronicznego wywoania zwrotnego";
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Gwny punkt wejcia dla aplikacji.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new ThreadPoolTestForm());
		}

		private void StartNewAppDomain()
		{
			try
			{
				Debug.WriteLine("Uruchomienie z identyfikatorem wtku: " + Convert.ToString(Thread.CurrentThread.GetHashCode()));

				string appDomainName = "RemoteDomain" + Convert.ToString(appDomainCount);
				// Ustawienie ApplicationBase na aktualny katalog

				AppDomainSetup info = new AppDomainSetup();

				info.ApplicationBase = "file:\\\\" + System.Environment.CurrentDirectory;

				// Utworzenie domeny aplikacji z pustym dowodem

				AppDomain dom = AppDomain.CreateDomain(appDomainName, null, info);

				// Uruchomienie podzespou przez AppDomain

				dom.ExecuteAssembly("DiningPhilosophers.exe");

				// Oczyszczenie poprzez usunicie domeny aplikacji z pamici

				AppDomain.Unload(dom);  

				Interlocked.Decrement(ref appDomainCount);
				appDomainCountTextBox.Text = Convert.ToString(appDomainCount);
				appDomainCountTextBox.Refresh();

				Debug.WriteLine("Wyjcie z identyfikatorem wtku: " + Convert.ToString(Thread.CurrentThread.GetHashCode()));
			}
			catch(Exception e)
			{
				Debug.WriteLine(e.ToString());
			}
		}
		private void OnStart(object sender, System.EventArgs e)
		{
			Interlocked.Increment(ref appDomainCount);
			appDomainCountTextBox.Text = Convert.ToString(appDomainCount);
			appDomainCountTextBox.Refresh();
			Thread t = new Thread(new ThreadStart(StartNewAppDomain));
			t.Start();
			// StartNewAppDomain();
		}
	}
}
